<?php
add_shortcode( 'humanlogica-faq', 'humanlogica_faq' );
function humanlogica_faq(){
    ob_start();
    
    $get_faq = get_field('input_faqs', 'option');

    //var_dump($get_faq);

    ?>
    <div class="faq-container">
        <?php if( $get_faq ): ?>
            <div id="faq">
                <?php $count = 1; ?>
                <?php foreach( $get_faq as $index => $faq ): ?>
                    <div class="faq-item">
                        <div class="faq-question" data-index="<?php echo $index; ?>">
                            <div class="fq-number">
                                <?php echo sprintf('%02d', $count); ?>
                            </div>
                            <div class="fq-title">
                                <h3><?php echo $faq['question']; ?></h3>
                                <span class="faq-icon"><?php echo $index === 0 ? '-' : '+'; ?></span>
                            </div>
                        </div>
                        <div class="faq-answer" style="display: <?php echo $index === 0 ? 'block' : 'none'; ?>;">
                            <?php echo $faq['answer']; ?>
                        </div>
                    </div>
                    <?php $count++; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    <?php

    return ob_get_clean();

}

add_shortcode('event-time-details', 'event_time_details');
function event_time_details(){
    ob_start();
    $get_event_time = get_field('event_time');
    $get_event_location = get_field('event_location');
    //var_dump($get_event_time);

    ?>
    <div class="event-date-time-details">
        <div class="edtd-date-time">
            <div class="edt-icon">
                <img src="<?php echo HUMANLOGICA_URL . 'assets/image/ic-calendar.svg'; ?>">
            </div>
            <div class="edt-detail">
                <?php
                $timestamp = strtotime($get_event_time['date']);
                $dayName = date("l", $timestamp);
                ?>
                <span class="ed-date"><?php echo $get_event_time['date']; ?></span>
                <span class="ed-time"><?php echo $dayName . ', ' . $get_event_time['time_start'] . ' - ' . $get_event_time['end_time']; ?></span>
            </div>
        </div>
        <div class="edtd-location">
            <div class="edt-icon">
                <img src="<?php echo HUMANLOGICA_URL . 'assets/image/ic-location.svg'; ?>">
            </div>
            <div class="edt-detail">
                <span class="ed-place"><?php echo $get_event_location['place_name']; ?></span>
                <span class="ed-location"><?php echo $get_event_location['location_details']; ?></span>
            </div>
        </div>
    </div>
    <?php

    
    return ob_get_clean();
}

add_shortcode('loop-event-details', 'loop_event_details');
function loop_event_details(){
    ob_start();
    $get_event_location = get_field('event_location');
    $get_event_time = get_field('event_time');
    
    ?>
    <div class="le-details">
        <div class="ld-date">
            <?php
            $date_post = get_the_date();
            echo date("M y", strtotime($date_post));
            ?>
        </div>
        <div class="ld-details">
            <a href="<?php echo get_permalink(); ?>" class="ld-title"><?php echo get_the_title(); ?></a>
            <span class="ld-location"><?php echo $get_event_location['location_details']; ?></span>
            <span class="ld-time"><?php echo $get_event_time['time_start'] . ' - ' . $get_event_time['end_time']; ?></span>
            <div class="ld-event-code">
                <span class="lec-code">
                    <img src="<?php echo HUMANLOGICA_URL . 'assets/image/ic-ticket.svg'; ?>">
                    <?php echo get_field('event_code'); ?>
                </span>
                <div class="lec-interest">
                    <img src="<?php echo HUMANLOGICA_URL . 'assets/image/ic-star.svg'; ?>">
                    <span>
                    <?php
                    $views = get_post_meta(get_the_ID(), 'page_views', true);
                    echo ($views ? $views : '0') . ' interested';
                    ?>
                    </span>
                </div>
            </div>
        </div>
    </div>
    <?php

    return ob_get_clean();
}

add_shortcode('humanlogica-clients', 'humanlogica_clients');
function humanlogica_clients(){
    $get_clients = get_field('input_client', 'option');
    //var_dump($get_clients);

    ob_start();

    ?>
    <div class="humanlogica-clients-container clients-carousel owl-carousel">
        <?php
        foreach($get_clients as $client){
            ?>
            <div class="hcc-item">
                <div class="hcci-img">
                    <img src="<?php echo $client['profile_image']; ?>" class="hi-profile-img">
                    <img src="<?php echo HUMANLOGICA_URL . 'assets/image/ic-review.svg'; ?>" class="hi-icon-review">
                </div>
                <div class="hcci-content">
                    <span class="hc-review"><?php echo $client['review']; ?></span>
                    <span class="hc-name"><?php echo $client['name']; ?></span>
                    <span class="hc-job"><?php echo $client['job']; ?></span>
                </div>
            </div>
            <?php
        }
        ?>
    </div>
    <?php

    return ob_get_clean();
}

add_shortcode('cyberbang-insight', 'cyberbang_insight');
function cyberbang_insight(){
    ob_start();

    $args = array(
        'post_type'      => 'post', // Jenis post (default: 'post')
        'posts_per_page' => 3,     // Jumlah post yang ditampilkan
        'order'          => 'DESC', // Urutan post (ASC/DESC)
        'orderby'        => 'date', // Urut berdasarkan apa (date, title, etc.)
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) :
        echo '<div class="cyberbang-insight">';
        while ($query->have_posts()) : $query->the_post();
            if ($query->current_post === 0) {
                // Kondisi untuk loop pertama
                ?>
                <div class="cbi-item-first" style="background-image:url('<?php echo get_the_post_thumbnail_url(get_the_ID(), 'full'); ?>'">
                    <div class="cif-title">
                        <h2><?php echo the_title(); ?></h2>
                        <a href="<?php the_permalink(); ?>" class="btn-view-more">View More</a>
                    </div>
                </div>
                <?php
            } else {
                ?>
                <div class="cbi-item-other">
                    <div class="cio-img">
                        <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'full'); ?>">
                    </div>
                    <div class="cio-title">
                        <h2><?php the_title(); ?></h2>
                        <a href="<?php the_permalink(); ?>" class="btn-view-more">View More</a>
                    </div>
                </div>
                <?php
            }
        endwhile;
        echo '</div>';
        wp_reset_postdata(); // Selalu reset postdata setelah loop
    else :
        echo '<p>No posts found.</p>';
    endif;

    return ob_get_clean();
}