<?php

namespace DynamicOOOS\TelegramBot\Api\Types;

use DynamicOOOS\TelegramBot\Api\BaseType;
use DynamicOOOS\TelegramBot\Api\InvalidArgumentException;
use DynamicOOOS\TelegramBot\Api\TypeInterface;
/**
 * Class Audio
 * This object represents an audio file (voice note).
 *
 * @package TelegramBot\Api\Types
 */
class Audio extends BaseType implements TypeInterface
{
    /**
     * {@inheritdoc}
     *
     * @var array
     */
    protected static $requiredParams = ['file_id', 'duration'];
    /**
     * {@inheritdoc}
     *
     * @var array
     */
    protected static $map = ['file_id' => \true, 'duration' => \true, 'performer' => \true, 'title' => \true, 'mime_type' => \true, 'file_size' => \true];
    /**
     * Unique identifier for this file
     *
     * @var string
     */
    protected $fileId;
    /**
     * Photo width
     *
     * @var int
     */
    protected $duration;
    /**
     * Optional. Performer of the audio as defined by sender or by audio tags
     *
     * @var string
     */
    protected $performer;
    /**
     * Optional. Title of the audio as defined by sender or by audio tags
     *
     * @var string
     */
    protected $title;
    /**
     * Optional. MIME type of the file as defined by sender
     *
     * @var string
     */
    protected $mimeType;
    /**
     * Optional. File size
     *
     * @var int
     */
    protected $fileSize;
    /**
     * @return int
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * @param int $duration
     *
     * @throws InvalidArgumentException
     */
    public function setDuration($duration)
    {
        if (\is_integer($duration)) {
            $this->duration = $duration;
        } else {
            throw new InvalidArgumentException();
        }
    }
    /**
     * @return string
     */
    public function getPerformer()
    {
        return $this->performer;
    }
    /**
     * @param string $performer
     */
    public function setPerformer($performer)
    {
        $this->performer = $performer;
    }
    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }
    /**
     * @return string
     */
    public function getFileId()
    {
        return $this->fileId;
    }
    /**
     * @param string $fileId
     */
    public function setFileId($fileId)
    {
        $this->fileId = $fileId;
    }
    /**
     * @return int
     */
    public function getFileSize()
    {
        return $this->fileSize;
    }
    /**
     * @param int $fileSize
     *
     * @throws InvalidArgumentException
     */
    public function setFileSize($fileSize)
    {
        if (\is_integer($fileSize)) {
            $this->fileSize = $fileSize;
        } else {
            throw new InvalidArgumentException();
        }
    }
    /**
     * @return string
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * @param string $mimeType
     */
    public function setMimeType($mimeType)
    {
        $this->mimeType = $mimeType;
    }
}
